echo "Install SQL Server 2022 and SQLEXPRESS..."
PowerShell.exe -NoProfile -ExecutionPolicy Bypass -Command "& {Start-Process PowerShell -Wait -ArgumentList '-NoProfile -ExecutionPolicy Bypass -File ""%~dp0\UnzipAndRunInstallerScript.ps1""' -Verb RunAs}"
rem timeout 180

set "SQLEXPRESS_REG_KEY_Exists=false"
set "varE=ABC"
@echo off
echo "Check existence of SQLEXPRESS registry key"
SETLOCAL ENABLEDELAYEDEXPANSION
:while
if !SQLEXPRESS_REG_KEY_Exists! == false (
    rem https://docs.microsoft.com/en-us/windows-server/administration/windows-commands/reg-query
    rem https://www.rushis.com/windows-command-prompt-redirecting-stdoutstderr/
    rem reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\SQLEXPRESS" > alloutput.log 2>&1
    rem JIRA Ticket: BFM-525
    rem Task: Set output and error of reg query command of SQLEXPRESS registry key to a variable
    rem StackOverflow Reference: https://stackoverflow.com/questions/6359820/how-to-set-commands-output-as-a-variable-in-a-batch-file
    rem StackOverflow Reference: https://stackoverflow.com/questions/34486993/batch-set-output-and-error-of-a-command-to-separate-variables
    FOR /F "tokens=* USEBACKQ" %%F IN (`reg query "HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Microsoft SQL Server\MSSQL16.SQLEXPRESS" 2^>^&1`) DO (
        SET varE=%%F
    )
    rem Check whether varE contains SQLEXPRESS string. SQLEXPRESS registry key string will be assigned to varE if the SQLEXPRESS registry key exists.
    If NOT "!varE!"=="!varE:SQLEXPRESS=!" (
        rem echo "Yes, line in alloutput.log contains SQLEXPRESS registry key"
        echo ""Found MSSQL16.SQLEXPRESS registry key. Wait for the remaining SQL Server 2022 installation features to be completed."
        set "SQLEXPRESS_REG_KEY_Exists=true"
        rem timeout 100
        timeout 10
    ) else (
        rem echo "Not yet found SQLEXPRESS registry key. Timeout for 15 seconds"
        echo "Couldn't find MSSQL16.SQLEXPRESS registry key."
        rem timeout 15
        timeout 5
        rem goto :while
    )
	
    rem https://stackoverflow.com/questions/4527877/batch-script-read-line-by-line/4527915
    rem https://stackoverflow.com/questions/13805187/how-to-set-a-variable-inside-a-loop-for-f
    rem SETLOCAL ENABLEDELAYEDEXPANSION enables an additional syntax, !variable!. This also expands variables but it only does so right before each (sub-)command is executed.
	rem 
	rem SETLOCAL ENABLEDELAYEDEXPANSION
    rem for /f "tokens=*" %%a in (alloutput.log) do (
	rem     set lineA=%%a
    rem     If NOT "!lineA!"=="!lineA:SQLEXPRESS=!" (
            rem echo "Yes, line in alloutput.log contains SQLEXPRESS registry key"
    rem 	echo ""Found SQLEXPRESS registry key. Wait for the remaining SQL Server 2012 installation features to be completed"
    rem        set "SQLEXPRESS_REG_KEY_Exists=true"
    rem        timeout 80
        )
    )
    rem echo !SQLEXPRESS_REG_KEY_Exists!
    rem echo !lineA!
	
    rem if !SQLEXPRESS_REG_KEY_Exists! == false (
    rem     echo "Not yet found SQLEXPRESS registry key. Timeout for 15 seconds"
    rem     timeout 15
    rem     goto :while
    rem )
    rem https://stackoverflow.com/questions/48964444/how-to-assign-something-to-global-variable-from-within-for-loop-in-batch
    rem endlocal
    rem echo %errorlevel%
    rem if %errorlevel% equ 0 (
    rem    echo ""Found SQLEXPRESS registry key"
    rem    set "SQLEXPRESS_REG_KEY_Exists=true"
    rem    timeout 8
    rem ) else (
    rem    echo "Not yet found SQLEXPRESS registry key. Timeout for 15 seconds"
    rem    timeout 15
    rem    goto :while
    rem )
    rem goto :while
)
endlocal
rem echo "Exit While Loop as SQLEXPRESS registry key exists. Wait for the remaining SQL Server 2012 installation features to be completed"
rem timeout 60
rem set SQLEXPRESS_REG_KEY_Exists = false
rem reg query mykey%SQLEXPRESS >nul
rem if %errorlevel% equ 1 (
rem     timeout 15
rem	echo "mykey exists"
rem ) else (
rem  echo "mykey exists"
rem )

rem timeout 380